(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     30732,        946]
NotebookOptionsPosition[     27992,        863]
NotebookOutlinePosition[     28583,        883]
CellTagsIndexPosition[     28540,        880]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Schmidt Camera", "Title"],

Cell[CellGroupData[{

Cell["Main function", "Subsection"],

Cell[TextData[StyleBox["SchmidtCamera",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["f1",
           FontWeight->Bold], Cell["focal length of the primary mirror"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["thick",
           FontWeight->Bold], Cell["thickness of the corrector"]},
         {Cell["diam",
           FontWeight->Bold], Cell["diameter of the primary mirror"]},
         {Cell["\[Alpha]",
           FontWeight->Bold], Cell[
          "form factor of the second surface of the corrector"]},
         {Cell["\[Theta]",
           FontWeight->Bold], Cell["field angle in degrees"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interface function", "Subsection"],

Cell[TextData[{
 StyleBox["SchmidtCameraInputPanel",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 " (no argument required, it creates a panel to work with the main function \
by means of easy controls and input fields)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary function", "Subsection"],

Cell[TextData[StyleBox["TotalAberrations",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["rad",
           FontWeight->Bold], Cell["list of the radii of the surfaces"]},
         {Cell["thick",
           FontWeight->Bold], Cell["\<\
list of the distances between the surfaces along the optical axis\
\>"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["costasf",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"list of the constants which characterize the nature of any \
surface\"\>"},
             {"\<\"(0 for a sphere, K for a conic, {a4, as} for an aspheric \
surface)\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["stoprad",
           FontWeight->Bold], Cell["radius of the aperture stop"]},
         {Cell["nstop",
           FontWeight->Bold], Cell["number of the surfaces before the stop"]},
         {Cell["dis",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"if nstop = 0, is the (negative) distance of the aperture \
stop from the first surface after it\"\>"},
             {"\<\"if nstop > 0,  is the distance between the last surface \
before the aperture stop and the aperture stop\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["dobject",
           FontWeight->Bold], Cell[
          "distance of the object from the first surface"]},
         {Cell["hobject",
           FontWeight->Bold], Cell["\<\
height of the object (only if the object is at a finite distance)\
\>"]},
         {Cell["angle",
           FontWeight->Bold], Cell[
          "view angle in degrees (if the object is at infinity)"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]},
         {"\[SpanFromAbove]", Cell["Coefficients"], Cell[
          "gives only aberration coefficients"]},
         {"\[SpanFromAbove]", Cell["None"], Cell["doesn't show any result"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Output variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["GOn",
           FontWeight->Bold], Cell["Number of surface"]},
         {Cell["GOren",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the entrance pupil for \"",SubscriptBox[
            "\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOwen",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOrexit",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the exit pupil for \"",SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOdistancefp",
           FontWeight->Bold], Cell[
          "Distance of the first principal plane from the first surface"]},
         {Cell["GOdistancesp",
           FontWeight->Bold], Cell[
          "Distance of the second principal plane from the last surface"]},
         {Cell["GOdistancegauss",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOfocalLength",
           FontWeight->Bold], Cell["Focal length"]},
         {Cell["GOimageHeight",
           FontWeight->Bold], Cell["Image height"]},
         {Cell["GOaberration",
           FontWeight->Bold], Cell["Third-order spherical aberration "]},
         {Cell["GOcoma",
           FontWeight->Bold], Cell["Third-order coma"]},
         {Cell["GOastigmatism",
           FontWeight->Bold], Cell["Third-order astigmatism"]},
         {Cell["GOcurvature",
           FontWeight->Bold], Cell["Third-order total curvature"]},
         {Cell["GOSeidelCurvature",
           FontWeight->Bold], Cell["Third-order curvature coefficient"]},
         {Cell["GOPetzvalRadius",
           FontWeight->Bold], Cell["Petzval radius"]},
         {Cell["GOdistortion",
           FontWeight->Bold], Cell["Third-order distortion"]},
         {Cell["GOSphericalCoefficient",
           FontWeight->Bold], Cell["Spherical Coefficient"]},
         {Cell["GOComaCoefficient",
           FontWeight->Bold], Cell["Coma Coefficient"]},
         {Cell["GOAstigmatismCoefficient",
           FontWeight->Bold], Cell["Astigmatism Coefficient"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Schmidt Camera", "Title"],

Cell[TextData[{
 "This notebook  designs Schmidt Cameras. In its first part, the foundations \
of this configuration are discussed whereas, in the second part, the program \
and its applications are contained. \nThe analysis of  a Schmidt's Camera \
starts from the evaluation of the aberrations of the optical combination \
formed by a spherical mirror ",
 Cell[BoxData[
  FormBox[
   RowBox[{"S", ","}], TraditionalForm]]],
 " with a focal length ",
 Cell[BoxData[
  FormBox["\[ScriptF]", TraditionalForm]]],
 ", and a plate C, located in front of ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 " at a distance  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[ScriptF]"}], TraditionalForm]]],
 ". The aperture stop coincides with the rim of corrector C. If the thickness \
of C is initially neglected, then we have (the variables f, Ni, a4, as, r, x, \
\[Theta], \[Lambda]1 have to be unassigned, for that we use Clear)"
}], "Text",
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "f", ",", "Ni", ",", "a4", ",", "as", ",", "r", ",", "x", ",", "\[Theta]", 
    ",", "\[Lambda]1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rad", "=", 
    RowBox[{"{", 
     RowBox[{"Infinity", ",", "Infinity", ",", 
      RowBox[{
       RowBox[{"-", "2"}], "f"}]}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"2", "f"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "Ni", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"a4", ",", "as"}], "}"}], ",", "0"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"stoprad", "=", "r"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nstop", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dis", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dobject", "=", 
   RowBox[{"-", "Infinity"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hobject", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"angle", "=", "\[Theta]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "stoprad", ",", 
   "nstop", ",", "dis", ",", "dobject", ",", "hobject", ",", "angle", ",", 
   RowBox[{"{", "\[Lambda]1", "}"}], ",", " ", 
   RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}], ",", " ", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Coefficients\>\""}]}], 
  "]"}]}], "Input"],

Cell["\<\
In order to find the value of a4 which eliminates the spherical aberration, \
we must solve the equation\
\>", "Text",
 FontSize->18],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"32", " ", 
         SuperscriptBox["f", "3"]}]]}], "+", 
      RowBox[{"a4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "Ni"}], ")"}]}]}], "\[Equal]", "0"}], ",", 
    "a4"}], "]"}], "//", "Flatten"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Schmidt Camera Summary", "Title"],

Cell[TextData[{
 "Aberration coefficients of the mirror ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 " with the aperture stop ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]]],
 " at a distance ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Delta]", " ", "f", " "}], TraditionalForm]]],
 "from ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]]
}], "Text"],

Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{"DS1", "=", 
    RowBox[{"-", 
     FractionBox["1", 
      RowBox[{"32", " ", 
       SuperscriptBox["f", "3"]}]]}]}], ";"}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{"DS2", " ", "=", " ", "0"}], ";"}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{"DS3", " ", "=", " ", "0"}], ";"}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{"DS5", " ", "=", " ", "0."}], TraditionalForm]}], "DisplayFormula"],

Cell["Aspherical coefficient of corrector", "Text"],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["a", "4"], " ", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"32", " ", 
      SuperscriptBox["f", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"Ni", "-", "1"}], ")"}]}]], ".", "  "}]}], 
  TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
 "Starting from the above formulae, good results are obtained for speeds of ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 " is less or equal to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "/", "3"}], TraditionalForm]]],
 ". For speeds in the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "/", "3"}], "-", 
    RowBox[{"F", "/", "2"}]}], TraditionalForm]]],
 " , we should"
}], "Text"],

Cell[TextData[{
 "consider the finite value of the curvature radius of the second surface of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 " in the computation of aberrations"
}], "Item"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["R", "c"], "=", 
    RowBox[{"-", 
     FractionBox["1", 
      RowBox[{
       SubscriptBox["a", "4"], 
       SuperscriptBox["\[Alpha]", "2"], 
       SuperscriptBox["r", "2"]}]]}]}], ","}], 
  TraditionalForm]], "DisplayFormula"],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", " "}], TraditionalForm]]],
 "is the form factor of the surface and ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]]],
 " the radius of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"A", " "}], TraditionalForm]]],
 ";"
}], "ItemParagraph"],

Cell["balance the third and fifth-order spherical aberrations;", "Item"],

Cell["control the chromatic aberration", "Item"],

Cell[TextData[{
 "Finally, for speed  greater than ",
 Cell[BoxData[
  FormBox[Cell[TextData[{
    Cell[BoxData[
     FormBox[
      RowBox[{"F", "/", "2"}], TraditionalForm]]],
    ","
   }]], TraditionalForm]]],
 " a sixth-order profile for the second surface of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]]],
 " is necessary. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SchmidtCamera Examples", "Title"],

Cell["\<\
To use the SchmidtCamera function you can either use directly the function \
SchmidtCamera[f1, ind, thick, diam, \[Alpha], \[Theta]] or use the \
interactive panel created by calling the function SchmidtCameraInputPanel[]. \
It, let\[CloseCurlyQuote]s you to set input  values and then call the \
SchmidtCamera function. Moreover, it helps to load examples from the saved \
archives and set the output style.
Here are some examples\
\>", "Text"],

Cell["Schmidt's camera F/4", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "=", "800."}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1.5187", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.5224", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.5143", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";", " ", 
  RowBox[{"(*", "BK7", "*)"}], "\n", 
  RowBox[{"thick", "=", "8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", "0.866"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", 
   RowBox[{"-", "1.5"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "generates", " ", "a", " ", "new", " ", "notebook", " ", 
    "with", " ", "a", " ", "report", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"SchmidtCamera", "[", 
   RowBox[{
   "f", ",", "ind", ",", "thick", ",", "diam", ",", "\[Alpha]", ",", 
    "\[Theta]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "the", 
    " ", "summary", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"SchmidtCamera", "[", 
   RowBox[{
   "f", ",", "ind", ",", "thick", ",", "diam", ",", "\[Alpha]", ",", 
    "\[Theta]", ",", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "only", 
    " ", "the", " ", "output", " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"SchmidtCamera", "[", 
   RowBox[{
   "f", ",", "ind", ",", "thick", ",", "diam", ",", "\[Alpha]", ",", 
    "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"this", " ", "gives", " ", 
     RowBox[{"input", "/", "output"}], " ", "values", " ", "as", " ", "a", 
     " ", "Return", " ", "from", " ", "the", " ", "function"}], ",", " ", 
    RowBox[{
    "with", " ", "labels", " ", "for", " ", "each", " ", "variable"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"SchmidtCamera", "[", 
   RowBox[{
   "f", ",", "ind", ",", "thick", ",", "diam", ",", "\[Alpha]", ",", 
    "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Basic\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Full\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "this", " ", "gives", " ", "only", " ", "output", " ", "values", " ", 
     "as", " ", "a", " ", "Return", " ", "from", " ", "the", " ", 
     "function"}], ",", " ", 
    RowBox[{"with", " ", "no", " ", "labels", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"useful", " ", "for", " ", "cutting"}], "&"}], "pasting", " ",
        "operations"}], " "}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"SchmidtCamera", "[", 
   RowBox[{
   "f", ",", "ind", ",", "thick", ",", "diam", ",", "\[Alpha]", ",", 
    "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Values\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell["Schmidt' s camera F/3", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "=", "600."}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1.518722", ",", "1", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1.5224", ",", "1", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1.5143", ",", "1", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", "0.866"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "2"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"SchmidtCamera", "[", 
  RowBox[{
  "f", ",", "ind", ",", "thick", ",", "diam", ",", "\[Alpha]", ",", 
   "\[Theta]"}], "]"}]], "Input"],

Cell["Schmidt' s camera F/2.5", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "=", "500."}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1.5187", ",", "1", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1.5224", ",", "1", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1.5143", ",", "1", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", "0.866"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "2.3"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"SchmidtCamera", "[", 
  RowBox[{
  "f", ",", "ind", ",", "thick", ",", "diam", ",", "\[Alpha]", ",", 
   "\[Theta]"}], "]"}]], "Input"],

Cell["Schmidt' s camera F/2 ", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "=", "400."}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ind", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1.5187", ",", "1", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1.5224", ",", "1", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1.5143", ",", "1", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], " ", 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", "5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Alpha]", "=", "0.866"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "3"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"SchmidtCamera", "[", 
  RowBox[{
  "f", ",", "ind", ",", "thick", ",", "diam", ",", "\[Alpha]", ",", 
   "\[Theta]"}], "]"}]], "Input"],

Cell["Load examples from the archive using LoadExample ", "Text"],

Cell[BoxData[
 RowBox[{"LoadExample", "[", "\"\<SchmidtCamera\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"SchmidtCamera", "[", "]"}]], "Input"],

Cell["Use the GUI panel to have all parameters under control", "Text"],

Cell[BoxData[
 RowBox[{"SchmidtCameraInputPanel", "[", "]"}]], "Input"]
}, Open  ]]
},
WindowSize->{1338, 868},
WindowMargins->{{Automatic, 261}, {39, Automatic}},
TrackCellChangeTimes->False,
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "GeometricOptics.nb"]]}, Visible -> False, 
  FrontEndVersion -> "11.0 for Microsoft Windows (64-bit) (July 28, 2016)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 31, 0, 71, "Title"],
Cell[CellGroupData[{
Cell[635, 26, 35, 0, 43, "Subsection"],
Cell[673, 28, 108, 2, 46, "Text"],
Cell[784, 32, 1653, 43, 303, "Text"],
Cell[2440, 77, 2110, 53, 389, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4587, 135, 40, 0, 43, "Subsection"],
Cell[4630, 137, 249, 6, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4916, 148, 40, 0, 43, "Subsection"],
Cell[4959, 150, 111, 2, 46, "Text"],
Cell[5073, 154, 3193, 83, 551, "Text"],
Cell[8269, 239, 2296, 56, 473, "Text"],
Cell[10568, 297, 3465, 89, 849, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14082, 392, 31, 0, 71, "Title"],
Cell[14116, 394, 956, 23, 142, "Text"],
Cell[15075, 419, 1684, 52, 275, "Input"],
Cell[16762, 473, 143, 4, 46, "Text"],
Cell[16908, 479, 396, 14, 51, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17341, 498, 39, 0, 71, "Title"],
Cell[17383, 500, 364, 14, 46, "Text"],
Cell[17750, 516, 472, 15, 118, "DisplayFormula"],
Cell[18225, 533, 51, 0, 46, "Text"],
Cell[18279, 535, 287, 10, 56, "DisplayFormula"],
Cell[18569, 547, 430, 15, 46, "Text"],
Cell[19002, 564, 195, 5, 26, "Item"],
Cell[19200, 571, 296, 11, 56, "DisplayFormula"],
Cell[19499, 584, 310, 13, 26, "ItemParagraph"],
Cell[19812, 599, 72, 0, 26, "Item"],
Cell[19887, 601, 48, 0, 26, "Item"],
Cell[19938, 603, 348, 13, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20323, 621, 39, 0, 71, "Title"],
Cell[20365, 623, 455, 8, 118, "Text"],
Cell[20823, 633, 36, 0, 46, "Text"],
Cell[20862, 635, 800, 25, 143, "Input"],
Cell[21665, 662, 432, 11, 55, "Input"],
Cell[22100, 675, 479, 12, 55, "Input"],
Cell[22582, 689, 511, 12, 55, "Input"],
Cell[23096, 703, 661, 15, 55, "Input"],
Cell[23760, 720, 780, 19, 55, "Input"],
Cell[24543, 741, 37, 0, 46, "Text"],
Cell[24583, 743, 818, 26, 143, "Input"],
Cell[25404, 771, 159, 4, 32, "Input"],
Cell[25566, 777, 39, 0, 46, "Text"],
Cell[25608, 779, 818, 26, 143, "Input"],
Cell[26429, 807, 159, 4, 32, "Input"],
Cell[26591, 813, 38, 0, 46, "Text"],
Cell[26632, 815, 816, 26, 143, "Input"],
Cell[27451, 843, 159, 4, 32, "Input"],
Cell[27613, 849, 65, 0, 46, "Text"],
Cell[27681, 851, 84, 1, 32, "Input"],
Cell[27768, 854, 61, 1, 32, "Input"],
Cell[27832, 857, 70, 0, 46, "Text"],
Cell[27905, 859, 71, 1, 32, "Input"]
}, Open  ]]
}
]
*)

